function [data,dataflds]=cpout(cpfile);
%
% Usage: [data,dataflds]=cpout(cpfile);
%
% Used to extract basic data from the matlab file output by CellProfiler
%
% CDATATYPE is a list of strings that occur in the CellProfiler data field
% names for information about CELLS. The field names containing any of the
% strings are identified, and the corresponding data is extracted from
% the CellProfiler output MATLAB file. For example, including
% 'Intensity_MeanIntensity' causes the mean intensity value for all of the
% cell observables to be extracted.
%
% NDATATYPE is a list of strings for NUCLEI data fields.
%
CDATATYPE={'Intensity_MeanIntensity_'};
NDATATYPE={'AreaShape_Eccentricity'; 'AreaShape_Area'; 'Location_Center_X'; 'Location_Center_Y'};
%
%
%
% Open the MATLAB file generated by CellProfiler
load(cpfile);
% 
%
%  Get the list of 'good' cells according to CellProfiler (those that are
%  not flagged BY CP as having an out-of-bound sized nucleus and that are
%  not touching the border of the image.
nucoksize=handles.Measurements.Nuclei.Children_NucsSized_Count{1};
celloffedge=handles.Measurements.Cells.Children_CellsInside_Count{1};
goodcelldx=find(nucoksize.*celloffedge>0);
%
%
%
%%% GET THE CELL SPECIFIC DATA
% get the list of CP field names for the data items in CDATATYPE
cdataflds=fieldnames(handles.Measurements.Cells);
cdatadx=[];
for dfdx=1:size(CDATATYPE,1)
    cdatadx=[cdatadx; find(~cellfun(@isempty,regexp(cdataflds(:),CDATATYPE(dfdx))))];
end
%
% eliminate redundant instances of a field name, and sort alphabetically
cdatadx=unique(cdatadx);
cdataflds=cdataflds(cdatadx);
cdataflds=sortrows(cdataflds);
%
% put the cell index and dapi fields at the front of the field names list
dapidx=find(~cellfun(@isempty,regexp(cdataflds(:),'DAPI')));
dapistr=cdataflds{dapidx};
cdataflds(dapidx)=[];
cdataflds=[dapistr; cdataflds];
cdataflds=['Number_Object_Number'; cdataflds];
%
% collect the data corresponding to the entries in the field names list
data=[];
for dfdx=1:size(cdataflds,1)
    dfldname=cdataflds{dfdx};
    data=[data,double(cell2mat(getfield(handles,'Measurements','Cells',dfldname)))];
end
%
%
%
%%% GET THE NUCLEI SPECIFIC DATA
% get the list of CP field names for the data items in NDATATYPE
ndataflds=fieldnames(handles.Measurements.Nuclei);
ndatadx=[];
for dfdx=1:size(NDATATYPE,1)
    ndatadx=[ndatadx; find(~cellfun(@isempty,regexp(ndataflds(:),NDATATYPE(dfdx))))];
end
%
% eliminate redundant instances of a field name, and sort alphabetically
ndatadx=unique(ndatadx);
ndataflds=ndataflds(ndatadx);
ndataflds=sortrows(ndataflds);
%
% collect the data corresponding to the entries in the field names list
for dfdx=1:size(ndataflds,1)
    dfldname=ndataflds{dfdx};
    data=[data,double(cell2mat(getfield(handles,'Measurements','Nuclei',dfldname)))];
end
%
%
%
%%% COMBINE THE CELL AND NUCLEI DATA INTO ONE MATRIX
dataflds=[cdataflds; ndataflds]
% eliminate cells that were flagged as problematic by CellProfiler
data=data(goodcelldx,:);
%
